--
-- VX_Sp_RegisterPhoneToDNC
--
-- Register a phone to do not call list, if the registration already exist 
-- we refresh the RegistrationDate with the today date ( UTC)
--
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_Sp_RegisterPhoneToDNC]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].VX_Sp_RegisterPhoneToDNC
GO

CREATE PROCEDURE VX_Sp_RegisterPhoneToDNC
	@phoneNumber varchar(20),
	@contextId int,
	@source  varchar(255) = null
AS
BEGIN

	IF EXISTS( SELECT * FROM DoNotCallList WHERE Phone= @phoneNumber AND ContextId = @contextId )
	BEGIN
		--refresh registration
		UPDATE DoNotCallList 
		SET RegistrationDate = GETUTCDATE(), [Source] = @source
		WHERE Phone = @phoneNumber AND ContextId = @contextId
	END
	ELSE
	BEGIN
		--New registration
		INSERT INTO DoNotCallList
		( Phone, RegistrationDate, CreatedOn, [Source], ContextId )
		VALUES
		( @phoneNumber, GETUTCDATE(), GETUTCDATE(), @source, @contextId )
	END
END
GO
